﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameFunctions/getPathValue.as"
// nestedEval.as
	// evalPath
	// resolveContainer
	// getImpliedValue
#include "gameFunctions/VOW.as"
define_move = function(command_obj)
{
	command_obj.run = function( thisCommand_obj )
	{
		function once( func ){
			var done = false;
			return function () {
				return done ? void 0 : ((done = true), func.apply(this, arguments));
			}
		}// once()
		
		
		// resolve "sprite"
		var isCommon;
		var spriteName = nestedEval( thisCommand_obj.data.sprite, "RAM", "_this" );
		if(spriteName == "this"){
			spriteName = _this._name;		// read the instance name of the rpgSprite that contains this script
			isCommon = _this._parent.is_common || false;
		}// if:  "this" is used
		if( isCommon ){
			thisCommand_obj.sprite = evalPath( spriteName, "COMMON", "_this" );
		}else{
			thisCommand_obj.sprite = evalPath( spriteName, "SPRITES", "_this" );
		}
		
		if(TRACE_SCRIPT)
			trace("move: "+spriteName);
		
		// store sprite reference within all child commands
		for(var m=0; m<this.script.length; m++){
			this.script[m].sprite = thisCommand_obj.sprite;
		}// for:  each move command
		
		// create a promise for this movement script
		var moveScript_vow = VOW.make();
		// add this movement script to the rpgSprite's list of currently-running movement scripts
		thisCommand_obj.sprite.currentMovements.add( moveScript_vow.promise );
				
		// construct event dispatcher
		thisCommand_obj.sprite.lastMove = {};		// create a lastMove object, indicating that this sprite is moving
		AsBroadcaster.initialize(thisCommand_obj.sprite.lastMove);		// allow it to send events
		
		
		// When this movement script finishes
		thisCommand_obj.script.thisCommand_obj = thisCommand_obj;
		thisCommand_obj.script.done = function(){
			// trigger one-time events, then clean-up
			if(TRACE_SCRIPT)
				trace("move done for: "+thisCommand_obj.sprite);
			this.thisCommand_obj.sprite.lastMove.broadcastMessage("onMotionFinished");
			this.thisCommand_obj.sprite.broadcastMessage("onMoveFinish");
			delete this.thisCommand_obj.sprite.lastMove;
			moveScript_vow.keep(true);		// true = movement successful		false = movement aborted
			thisCommand_obj.sprite.currentMovements.remove( moveScript_vow.promise );
			/*
			for(var L in this.thisCommand_obj.sprite.lastMove._listeners){
				var thisListener = this.thisCommand_obj.sprite.lastMove._listeners[L];
				this.thisCommand_obj.sprite.lastMove.removeListener( thisListener );
				delete thisListener;
			}// for:  each listener
			delete this.thisCommand_obj.sprite.lastMove;
			*/
		}// done()
		thisCommand_obj.script.done = once( thisCommand_obj.script.done );
		
		
		// allow movement to be aborted
		moveScript_vow.promise.abort = function( abortValue ){
			if(abortValue==="")					abortValue = undefined;
			if(abortValue===undefined)	abortValue = false;		// default
			if(abortValue==="true")			abortValue = true;
			if(abortValue==="false")		abortValue = false;
			thisCommand_obj.script.done = null;
			thisCommand_obj.sprite.currentMovements.remove( moveScript_vow.promise );
			moveScript_vow.keep(abortValue);		// true = movement successful		false = movement aborted
		}// abort()
		
		
		// start internal script
		thisCommand_obj.script.runEvent(0);
		
		// immediately continue the external script
		setTimeout( thisCommand_obj.nextEvent, 1 );
		//thisCommand_obj.nextEvent();
	}// run()
}// define_move()